/*
 * @(#)ZipMenuStyle.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.AbstractButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


import java.io.File;


/**
 * Class used to create the style menu, to chose the lokk and feel
 * @see AllActionListener
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMenuStyle extends JMenu {
   

    /**
     * Class constructor
     * @param allActionListener
     */
    public ZipMenuStyle(AllActionListener allActionListener) {
	super("Style");
	
	// create menu items
	JMenuItem windowsItem = new JMenuItem("Windows");
	JMenuItem motifItem = new JMenuItem("Motif");
	JMenuItem metalItem = new JMenuItem("Metal");

	// setup menu items
	windowsItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	motifItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	metalItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	windowsItem.setActionCommand("Windows");
	motifItem.setActionCommand("Motif");
	metalItem.setActionCommand("Metal");
	windowsItem.addActionListener(allActionListener);
	motifItem.addActionListener(allActionListener);
	metalItem.addActionListener(allActionListener);

	// add menu items
	add(windowsItem);
	add(motifItem);
	add(metalItem);
	

    }
}
